unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls;


type
  TForm1 = class(TForm)
    Button1: TButton;
    Timer1: TTimer;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    GroupBox2: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  stridani : boolean;

implementation

{$R *.DFM}

type
  TKeyType = (ktCapsLock, ktNumLock, ktScrollLock);

procedure SetLedState(KeyCode: TKeyType; bOn: Boolean);
var
  KBState: TKeyboardState;
  Code: Byte;
begin
  case KeyCode of
    ktScrollLock: Code := VK_SCROLL;
    ktCapsLock: Code := VK_CAPITAL;
    ktNumLock: Code := VK_NUMLOCK;
  end;
  GetKeyboardState(KBState);
  if (Win32Platform = VER_PLATFORM_WIN32_NT) then
  begin
    if Boolean(KBState[Code]) <> bOn then
    begin
      keybd_event(Code,
                  MapVirtualKey(Code, 0),
                  KEYEVENTF_EXTENDEDKEY,
                  0);

      keybd_event(Code,
                  MapVirtualKey(Code, 0),
                  KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP,
                  0);
    end;
  end
  else
  begin
    KBState[Code] := Ord(bOn);
    SetKeyboardState(KBState);
  end;
end;

procedure ClickRun;
begin
  if (form1.radiobutton2.Checked = true) and (stridani = true) then
  begin
    SetLedState(ktNumLock, true);  // NumLock on
    stridani := false;
  end
  else if form1.radiobutton2.Checked = true then
  begin
    SetLedState(ktNumLock, false);  // NumLock on
    stridani := true;
  end
  else if  (stridani = true) and (form1.radiobutton1.Checked = true) then
  begin
    SetLedState(ktScrollLock, true);  // ScrolLock on
    stridani := false;
  end
  else if form1.radiobutton1.Checked = true then
  begin
    SetLedState(ktScrollLock, false);  // ScrolLock on
    stridani := true;
  end
  else if  (stridani = true) and (form1.radiobutton3.Checked = true) then
  begin
    SetLedState(ktCapsLock, true);  // ktCapsLock on
    stridani := false;
  end
  else if form1.radiobutton3.Checked = true then
  begin
    SetLedState(ktCapsLock, false);  // ktCapsLock on
    stridani := true;
  end;
end;

procedure PressKey;
 var
    dwExtraInfo: DWORD;
    key:byte;
begin
  key := ord('a');
  //keybd_event(VK_NUMLOCK, VK_NUMLOCK, KEYEVENTF_EXTENDEDKEY, dwExtraInfo);
  keybd_event( key, key, KEYEVENTF_KEYUP, dwExtraInfo);
    //Informace o dalch kdech jsou v API Helpu (mapi.hlp) pod Virtual-Key Codes.
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  timer1.Interval := strtoint( Edit1.Text);
  timer1.Enabled := true;
  label1.Caption := 'Program b';
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  ClickRun();
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  timer1.Enabled := false;
  label1.Caption := 'Stop';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  stridani := true;
end;

end.
